/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.lazrslib.common.math;

import java.util.Random;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class MathUtilities {
    public static Vec3 GetPositionFromTowardsRotation(Vec3 from, double yaw, double pitch, double distance) {
        yaw = 57.2957763671875 * yaw;
        pitch = 57.2957763671875 * pitch;
        return MathUtilities.GetPositionFromTowardsRotationInDegrees(from, yaw, pitch, distance);
    }

    public static Vec3 GetPositionFromTowardsRotationInDegrees(Vec3 from, double yaw, double pitch, double distance) {
        float f = Mth.m_14089_((float)(-((float)yaw) * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = Mth.m_14031_((float)(-((float)yaw) * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -Mth.m_14089_((float)(-((float)pitch) * ((float)Math.PI / 180)));
        float f3 = Mth.m_14031_((float)(-((float)pitch) * ((float)Math.PI / 180)));
        return new Vec3((double)(f1 * f2) * distance, (double)f3 * distance, (double)(f * f2) * distance).m_82549_(from);
    }

    public static Vec3 GetVectorTowards(Vec3 from, Vec3 to) {
        Vec3 dir = to.m_82546_(from).m_82541_();
        return dir;
    }

    public static double GetYawFromDelta(Vec3 delta) {
        return Math.atan2(delta.f_82481_, delta.f_82479_);
    }

    public static double GetPitchFromDelta(Vec3 delta) {
        return Math.atan2(Math.sqrt(delta.f_82481_ * delta.f_82481_ + delta.f_82479_ * delta.f_82479_), delta.f_82480_) + Math.PI;
    }

    public static double invertRange(double v, double min, double max) {
        return -(v - min - (max - min));
    }

    public static double invert01(double v) {
        return -(v - 1.0);
    }

    public static Vec3 GetRandomPositionAroundPos(Vec3 pos, float radius) {
        Random r = new Random();
        float yaw = r.nextFloat() * 360.0f;
        float distance = r.nextFloat() * radius;
        return MathUtilities.GetPositionFromTowardsRotation(pos, yaw, 0.0, distance);
    }

    public static Vec3 GetRandomPositionSphericallyAroundPos(Vec3 pos, float radius) {
        Random r = new Random();
        float yaw = r.nextFloat() * 360.0f;
        float pitch = r.nextFloat() * 360.0f;
        float distance = r.nextFloat() * radius;
        return MathUtilities.GetPositionFromTowardsRotation(pos, yaw, pitch, distance);
    }
}

